set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '2021314',
      24,
      3,
      1.437795,
      3,
      '313113',
      NULL,
      '11-16-1986',
      39.222026,
      NULL,
      0,
      NULL,
      1.157973,
      1,
      1.301995,
      1,
      1.121998,
      1,
      2.799525,
      1,
      0,
      1,
      0,
      1,
      1.391506,
      NULL,
      1.976140,
      1.441940,
      0.670835,
      0.016306,
      4,
      0.571196,
      NULL,
      0.727811,
      0.376669,
      1,
      NULL,
      NULL,
      3,
      0.649839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.032491,
      0,
      1,
      2,
      3.645348,
      0,
      2.706221,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      0.458751,
      0.963949,
      3,
      0,
      0.177117,
      NULL,
      0.811694,
      1.670380,
      5,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.377236,
      NULL,
      NULL,
      0.669028,
      1,
      1,
      1,
      0.425613,
      0,
      1.509548,
      0.519318,
      0.262101,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0.050450,
      1,
      0,
      NULL,
      1.578264,
      4.490304,
      0.642733,
      1,
      NULL,
      NULL,
      0.968696,
      0.765685,
      5,
      0.481437,
      1,
      0.790081,
      1.667710,
      0.197677,
      1,
      0,
      1.433380,
      4,
      5.679257,
      2,
      0.848033,
      4,
      3.700502,
      7,
      3,
      NULL,
      NULL,
      3.066369,
      0.208244,
      NULL,
      NULL,
      1.353252,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715251,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.467311,
      NULL,
      NULL,
      0.620787,
      1.266803,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.056543,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075043,
      5.358880,
      2.671187,
      0.525325,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133930,
      0,
      2.180189,
      NULL,
      2,
      NULL,
      1,
      2.158519,
      0.116005,
      2.121250,
      0.750803,
      1.881204,
      NULL,
      NULL,
      1,
      0.899954,
      1.763523,
      1.034125,
      0.868104,
      1.061741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.132132,
      '23403',
      '',
      '',
      1.755616,
      '',
      '',
      '',
      0.546366,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


