set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '0133014',
      92,
      2,
      0,
      0,
      '221031',
      1,
      ' 4-24-1997',
      15,
      NULL,
      1,
      NULL,
      1.168916,
      1.260947,
      NULL,
      1,
      1.788563,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.512896,
      1.851906,
      1,
      1,
      3.801471,
      0,
      NULL,
      1.735839,
      0.282806,
      0,
      NULL,
      0,
      NULL,
      1.955622,
      3.297242,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.479417,
      5.530252,
      2,
      NULL,
      2.459492,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      2,
      0.066082,
      1,
      1.201477,
      NULL,
      0,
      5.360059,
      NULL,
      2,
      1.295315,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.237215,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.091550,
      1.211126,
      0,
      0,
      0,
      0.408879,
      1.709354,
      0.592279,
      0,
      0.596498,
      1,
      NULL,
      0,
      0.729231,
      0.765755,
      NULL,
      0,
      0.136864,
      1,
      1.322436,
      3.973167,
      1,
      1.280405,
      NULL,
      NULL,
      1,
      3.640465,
      1.517087,
      1.114751,
      NULL,
      NULL,
      0,
      0.532714,
      0.747618,
      5.901955,
      NULL,
      NULL,
      3,
      0.007287,
      2,
      NULL,
      NULL,
      0.072151,
      NULL,
      1.978451,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.293069,
      1,
      0.957380,
      0.425617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005383,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1.028334,
      0,
      NULL,
      NULL,
      NULL,
      1.639434,
      0,
      4,
      2,
      1.055152,
      NULL,
      1.566832,
      NULL,
      NULL,
      NULL,
      1.212137,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186669,
      NULL,
      2,
      2,
      1.594411,
      0,
      NULL,
      3.956162,
      1,
      NULL,
      1.063669,
      0.857377,
      NULL,
      1,
      1,
      1.362750,
      0.062325,
      0,
      1,
      1.878068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


