set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      NULL,
      NULL,
      15,
      '2221403',
      98,
      2,
      2,
      NULL,
      '323300',
      0.047553,
      ' 4- 7-2003',
      14.541189,
      NULL,
      0,
      NULL,
      0,
      1.908601,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.093450,
      0.715802,
      4.456267,
      NULL,
      1,
      NULL,
      0,
      1,
      0.250060,
      1.362548,
      NULL,
      NULL,
      1,
      0.075743,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.297964,
      0.501467,
      1,
      NULL,
      3,
      1,
      0.910974,
      NULL,
      0.291701,
      1,
      0,
      0,
      0,
      2.939275,
      0,
      0,
      2.474060,
      0,
      0,
      0,
      0,
      5.178929,
      0,
      NULL,
      1,
      0.094665,
      1.802022,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.779804,
      NULL,
      0,
      0.431092,
      1.433844,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.603963,
      0,
      1,
      1.141825,
      NULL,
      0,
      0.060909,
      NULL,
      0.118803,
      NULL,
      0,
      1.115832,
      NULL,
      1,
      0.684195,
      1,
      2.641167,
      NULL,
      0,
      1,
      0.955385,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1,
      4,
      5,
      0.283775,
      0.725291,
      3.040075,
      1.009773,
      NULL,
      5.255138,
      1.500116,
      NULL,
      NULL,
      3.713048,
      1.139104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.218983,
      NULL,
      NULL,
      0.562558,
      0.153302,
      NULL,
      0.202538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      1.138804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.420207,
      0.018334,
      4,
      NULL,
      0,
      1.316290,
      NULL,
      NULL,
      NULL,
      0.097919,
      3.201897,
      0.034982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909394,
      3,
      1,
      0.398424,
      0,
      0.397481,
      1.613146,
      1,
      0,
      3.319030,
      NULL,
      0.028572,
      0,
      0.892587,
      NULL,
      1,
      1.154444,
      1.815215,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.073681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '40114',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2.549368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


