set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24',
      22.949704,
      NULL,
      '3303312',
      19.485081,
      6,
      1.387991,
      1,
      NULL,
      3,
      NULL,
      7,
      64,
      1.271953,
      NULL,
      0.214875,
      1,
      1.018024,
      0,
      1.889458,
      1.955867,
      2.745021,
      1,
      0,
      0.915069,
      1.927139,
      1,
      1.940381,
      NULL,
      1.701072,
      1,
      5,
      1,
      1,
      NULL,
      0.180057,
      1.550667,
      5,
      1,
      1.376484,
      0.407917,
      NULL,
      1.182274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.786137,
      NULL,
      1.986815,
      2.310921,
      1,
      NULL,
      1,
      1.422193,
      3.842118,
      0.501256,
      0,
      3.885743,
      2.672098,
      3.570313,
      0,
      2,
      0,
      1,
      1.677564,
      0,
      0.148890,
      1.136695,
      1,
      NULL,
      1.197741,
      0,
      NULL,
      NULL,
      0.172988,
      NULL,
      NULL,
      1.733441,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.999560,
      NULL,
      0.521948,
      0.749165,
      0,
      0.994856,
      0,
      0.213544,
      1.892840,
      NULL,
      1.864119,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1,
      2.509768,
      1.269353,
      5,
      2.492438,
      0.795594,
      2.486891,
      1.084917,
      1.864671,
      0.276135,
      0,
      0.071511,
      NULL,
      NULL,
      6.187201,
      NULL,
      2.125757,
      2,
      NULL,
      4,
      0.376512,
      3.596477,
      0,
      NULL,
      NULL,
      NULL,
      3.507283,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.666457,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.839572,
      NULL,
      4,
      3.164701,
      0.291957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374072,
      1.844185,
      1,
      NULL,
      NULL,
      NULL,
      0.579198,
      1.117536,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.662862,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.228636,
      1.023075,
      1,
      1.231121,
      1,
      NULL,
      3,
      0.240837,
      3,
      1.694406,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.545639,
      1.430303,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.474412,
      '03223',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.219589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


