set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '040',
      '22',
      36.265642,
      14.123871,
      NULL,
      131.032119,
      NULL,
      NULL,
      3,
      '321211',
      5,
      ' 4- 2-1989',
      33.494008,
      27,
      1.497190,
      NULL,
      1.315905,
      NULL,
      NULL,
      0.850341,
      1,
      1.368051,
      NULL,
      0.195869,
      NULL,
      1.026371,
      2.649557,
      NULL,
      0,
      1.450373,
      1.698190,
      1,
      NULL,
      0,
      6,
      2,
      1,
      0,
      NULL,
      0,
      2.237100,
      0.885962,
      0.227045,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.125791,
      NULL,
      1.935911,
      1.353619,
      0,
      0.601273,
      2,
      1.373829,
      1.391154,
      0.758525,
      NULL,
      2.526609,
      0.084842,
      NULL,
      1,
      NULL,
      1.456249,
      0,
      NULL,
      0.721060,
      NULL,
      2,
      5.927681,
      0,
      NULL,
      0.435204,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.612114,
      0.339661,
      NULL,
      1.950135,
      1.255918,
      0,
      1.405980,
      1,
      1.511696,
      1.437535,
      0.912759,
      0.588587,
      1,
      0.861517,
      1,
      NULL,
      NULL,
      1.649586,
      0,
      NULL,
      0.151600,
      4,
      1.748496,
      5,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1.435218,
      1.011342,
      NULL,
      1,
      1,
      2.668494,
      0.788835,
      3.705058,
      NULL,
      1.438141,
      NULL,
      1.668415,
      5.509829,
      3,
      5.065358,
      7,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.561912,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0.566301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.657953,
      3.931565,
      1.287143,
      0,
      1.125411,
      1.760767,
      NULL,
      0.472879,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.745494,
      6.734640,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.278672,
      NULL,
      2,
      2.126281,
      NULL,
      NULL,
      1.841538,
      0.778549,
      NULL,
      1,
      1.577298,
      NULL,
      NULL,
      1,
      0.036992,
      0,
      1.536356,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '11122',
      '',
      '',
      0.465199,
      '',
      '',
      '',
      2,
      '4230',
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


