set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '134',
      '32',
      25.527525,
      9.418659,
      '4413410',
      NULL,
      3,
      3.571447,
      2,
      '220102',
      1,
      ' 2-27-1999',
      45,
      NULL,
      0.818427,
      NULL,
      NULL,
      2.869039,
      0,
      NULL,
      1,
      0,
      2.608989,
      1.977802,
      1,
      0.021100,
      3,
      0,
      0,
      0.069504,
      0.707964,
      0,
      0.533025,
      0,
      3.883599,
      4,
      0,
      1,
      1.241796,
      0,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.197950,
      NULL,
      NULL,
      4.845669,
      NULL,
      0,
      1.926022,
      3,
      2,
      1,
      1,
      NULL,
      2.201433,
      0,
      1,
      3.828054,
      NULL,
      3.380089,
      NULL,
      NULL,
      0.960299,
      NULL,
      5,
      0,
      2.401995,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.498820,
      0.142877,
      0.308103,
      1,
      1,
      0,
      0.605435,
      1,
      NULL,
      0,
      NULL,
      0.302492,
      0.270450,
      NULL,
      0.177114,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.204229,
      NULL,
      0,
      1,
      3,
      NULL,
      0.858909,
      3,
      NULL,
      0.331566,
      NULL,
      1.538993,
      NULL,
      1,
      2.562703,
      0,
      4.884039,
      NULL,
      NULL,
      5.036780,
      3,
      1.395523,
      2.479230,
      NULL,
      7.538222,
      2.232971,
      1,
      NULL,
      NULL,
      9,
      1.562753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763486,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.957391,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029689,
      NULL,
      NULL,
      2,
      5.112248,
      0,
      0.547921,
      NULL,
      NULL,
      NULL,
      0,
      2.683743,
      1.371337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414995,
      1.936275,
      2,
      0,
      NULL,
      1.580347,
      1,
      NULL,
      0.221909,
      0.614960,
      1.048638,
      0,
      1.395258,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0.220792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389706,
      '30001',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.406688,
      NULL,
      NULL,
      '',
      0.349530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


