set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      NULL,
      36.642317,
      15.979451,
      NULL,
      92.244411,
      0,
      1.714850,
      1,
      '320014',
      NULL,
      ' 4- 1-1989',
      49,
      59.977150,
      0,
      NULL,
      1,
      3,
      1.438469,
      NULL,
      0,
      0.325479,
      0,
      1,
      1.506426,
      NULL,
      NULL,
      1.602516,
      1.194234,
      0.157926,
      1,
      NULL,
      2.927087,
      1.184970,
      2.039932,
      1,
      0.202481,
      NULL,
      0.291799,
      1,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.736780,
      0,
      0,
      3.978726,
      1,
      NULL,
      3,
      0.899681,
      1,
      0.208063,
      0.606855,
      3,
      1,
      NULL,
      1,
      2.075880,
      0,
      0.681283,
      0,
      0,
      NULL,
      0.644964,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.048516,
      2,
      0,
      1,
      1.557696,
      0,
      1,
      0.280684,
      1,
      1,
      0,
      NULL,
      1.396908,
      NULL,
      1,
      1,
      0,
      NULL,
      1.401720,
      NULL,
      NULL,
      1.162778,
      0.680898,
      1,
      3,
      1,
      NULL,
      1,
      4.992768,
      0,
      1,
      1,
      1.185388,
      NULL,
      0.337696,
      5.390106,
      7.154570,
      5,
      1,
      2,
      NULL,
      5,
      6.739392,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      2,
      1.340951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.505328,
      1,
      1,
      0,
      1,
      0.942610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1.187235,
      NULL,
      NULL,
      NULL,
      0,
      1.518150,
      NULL,
      1.609009,
      4,
      1,
      4,
      NULL,
      NULL,
      NULL,
      0,
      2.244404,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1.885816,
      0.404435,
      2.304564,
      1,
      1.552986,
      1,
      3,
      1.392255,
      0,
      1.422432,
      0.786761,
      1,
      NULL,
      1,
      0,
      1,
      0.720623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '02403',
      '',
      '',
      0,
      '',
      '',
      '',
      3.537441,
      '1222',
      '',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


