set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      '01',
      14,
      0,
      '1443200',
      94,
      6,
      1.512738,
      2,
      '444203',
      1.140881,
      ' 9- 6-1990',
      4,
      62,
      NULL,
      NULL,
      0,
      2.228737,
      0,
      0,
      0.995381,
      0,
      1,
      0.279106,
      1,
      0,
      1,
      0,
      1.301006,
      NULL,
      0.340338,
      1,
      0,
      1.857183,
      3,
      0,
      1.024342,
      0,
      2,
      1,
      1.250844,
      1.019843,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.622032,
      0.047349,
      3.994379,
      3.514424,
      0,
      2.461363,
      1,
      3.953565,
      1,
      0,
      3,
      1,
      0,
      1,
      2,
      NULL,
      1.448850,
      0.914478,
      4.738643,
      3.107018,
      2,
      3.496682,
      1,
      NULL,
      NULL,
      1.046413,
      NULL,
      NULL,
      1.204690,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4.111086,
      5,
      1,
      0.856278,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0.785316,
      0.235919,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.754863,
      NULL,
      NULL,
      4,
      0.789679,
      2,
      1.328750,
      5,
      NULL,
      0,
      NULL,
      0.760750,
      0.456737,
      1.785920,
      3.993192,
      4.969742,
      0.679749,
      3.709540,
      0,
      1.957578,
      NULL,
      4,
      0.416713,
      2.456232,
      1.063136,
      0.354927,
      0.065085,
      1.198966,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1.907656,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175133,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.600306,
      0,
      4.228060,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.548681,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.791273,
      NULL,
      NULL,
      2,
      3.895185,
      1,
      0.914057,
      0.356349,
      1.946285,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022536,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '24214',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.687989,
      '4140',
      '',
      NULL,
      3.610670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


