set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '12',
      NULL,
      9.789134,
      NULL,
      90,
      NULL,
      3.518107,
      NULL,
      '104210',
      5.613668,
      NULL,
      41,
      52.229468,
      0.696526,
      NULL,
      1,
      2.234259,
      0,
      NULL,
      0,
      0.295524,
      2.558738,
      0,
      0,
      NULL,
      0.240456,
      1.821431,
      0,
      NULL,
      0.236431,
      0,
      5.042116,
      0,
      4,
      5,
      NULL,
      1.267745,
      0,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.250277,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      3.060656,
      0,
      1.246000,
      1,
      0,
      3.695114,
      0,
      0.745675,
      3.735044,
      1.535038,
      0.562734,
      3.787134,
      1.707201,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1.400227,
      NULL,
      1.281174,
      NULL,
      1,
      0,
      0,
      1.392343,
      NULL,
      0.723093,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.584041,
      1,
      NULL,
      0,
      0,
      0,
      1.799352,
      3.710995,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.252651,
      1.006931,
      0.507355,
      5,
      0,
      5,
      NULL,
      NULL,
      2.788183,
      3.592017,
      3.093584,
      1,
      NULL,
      3.857698,
      3,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.802436,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      3,
      0.097738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.615822,
      0.109135,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      6,
      3.137467,
      4.492052,
      0,
      0.516935,
      NULL,
      NULL,
      NULL,
      3.786800,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      1.196485,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0.671118,
      1.605855,
      1,
      0,
      1,
      1,
      1.955211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '14010',
      '',
      '',
      0.143010,
      '',
      NULL,
      '',
      2,
      '0003',
      '',
      '',
      5,
      3,
      3,
      3.143292,
      3,
      0,
      0,
      3,
      2.190588);
commit;
end;
/


