set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '033',
      '24044003',
      NULL,
      31,
      '0411321',
      NULL,
      5,
      0.060542,
      0,
      '103200',
      5,
      NULL,
      10.252293,
      5,
      1.574362,
      NULL,
      0.559958,
      1.004153,
      1,
      NULL,
      1.401840,
      0,
      1,
      1.996279,
      0.161427,
      NULL,
      4.940638,
      NULL,
      1.514495,
      1,
      1,
      0.257735,
      NULL,
      0.400674,
      0,
      5,
      NULL,
      1,
      5,
      1,
      NULL,
      0,
      2.572666,
      1,
      NULL,
      NULL,
      0.050900,
      NULL,
      NULL,
      1.652112,
      1.455680,
      1,
      1.606268,
      0.588283,
      1.996403,
      3,
      0,
      NULL,
      0.604946,
      1.051678,
      1.926064,
      3,
      NULL,
      0,
      1,
      0,
      1,
      1.121804,
      1,
      2.264276,
      3,
      0.349482,
      0,
      1,
      1,
      1.469394,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.903331,
      NULL,
      NULL,
      5.292468,
      0.453957,
      1.597314,
      1.885622,
      1.536179,
      0.511672,
      0,
      0.095473,
      1,
      1,
      NULL,
      0,
      1.339551,
      0,
      0.425611,
      NULL,
      NULL,
      0.131876,
      NULL,
      0,
      3.996542,
      5.509811,
      0.976095,
      NULL,
      0,
      1.749221,
      NULL,
      1,
      2.575422,
      0.327834,
      1,
      0.947393,
      1,
      NULL,
      3.846518,
      2.612019,
      2.115477,
      2,
      1.668235,
      0,
      5.223013,
      1,
      4,
      9.884346,
      3.332462,
      2,
      0.163079,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.689589,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.465327,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765039,
      1,
      0,
      0.721711,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.017451,
      0.467359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.432032,
      NULL,
      1,
      1,
      NULL,
      1.865119,
      2.903860,
      1.504859,
      0,
      0.289378,
      NULL,
      0.851913,
      0,
      0.526361,
      NULL,
      1.116998,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '23010',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '0224',
      '',
      '',
      5.206802,
      NULL,
      2.477158,
      NULL,
      3,
      1.620558,
      0,
      3,
      3);
commit;
end;
/


