set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '12341233',
      32.989913,
      30.786356,
      NULL,
      NULL,
      2,
      1.676336,
      0,
      NULL,
      0,
      ' 1-19-1976',
      12.700854,
      53,
      1,
      NULL,
      NULL,
      2.362371,
      0,
      NULL,
      NULL,
      0,
      1.467239,
      0.464802,
      0,
      0.906576,
      5,
      1.030186,
      1,
      1.985139,
      0.861752,
      0,
      4.907228,
      0.320474,
      5.709384,
      0.248598,
      0.012511,
      NULL,
      2.681662,
      0,
      2,
      1,
      2.671045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.594361,
      NULL,
      3,
      0.422740,
      3,
      0.622405,
      3.321731,
      0.094516,
      1,
      2.695031,
      1.070570,
      NULL,
      1,
      3,
      3,
      0.056422,
      0,
      NULL,
      NULL,
      0.132111,
      1,
      4.881640,
      4.689731,
      NULL,
      0,
      0.716669,
      1,
      NULL,
      NULL,
      0.792598,
      NULL,
      NULL,
      0.403440,
      0.852569,
      1.536342,
      NULL,
      2,
      0.908431,
      1,
      0.997050,
      0.985660,
      0.904451,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1.774609,
      1.990569,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.931748,
      1.128309,
      0,
      3.789642,
      0.345967,
      NULL,
      3,
      1,
      0.911714,
      5.930618,
      NULL,
      NULL,
      0.134709,
      4.111256,
      NULL,
      NULL,
      5.398045,
      NULL,
      1.181705,
      NULL,
      1,
      1.157501,
      0.031333,
      0.277360,
      1.203239,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.909140,
      1.593189,
      1.553203,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.312923,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.736478,
      NULL,
      3.682146,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.332830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881287,
      1,
      2.570393,
      2,
      3.640743,
      NULL,
      NULL,
      2,
      0.094998,
      NULL,
      0.333893,
      NULL,
      NULL,
      0.527618,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.500773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517503,
      '01323',
      '',
      NULL,
      0.966483,
      '',
      '',
      '',
      0.164082,
      NULL,
      '',
      NULL,
      0.867589,
      1,
      1.026385,
      NULL,
      0.238363,
      2.634873,
      NULL,
      3,
      3.989433);
commit;
end;
/


