set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '21300322',
      1,
      50.022213,
      '0032034',
      NULL,
      NULL,
      0.197893,
      0,
      NULL,
      5,
      ' 1-15-1998',
      12.938212,
      NULL,
      0.578330,
      NULL,
      NULL,
      0.123822,
      1.961382,
      0.680441,
      1,
      NULL,
      1.210063,
      NULL,
      0,
      1,
      0,
      1,
      0.677819,
      0,
      1.044898,
      0.180707,
      1.821988,
      NULL,
      2.291509,
      3,
      0.964313,
      0,
      NULL,
      0,
      4,
      NULL,
      NULL,
      1.713789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.792942,
      NULL,
      3,
      3,
      1,
      1,
      1,
      1.881540,
      1.960081,
      1,
      3.717780,
      1,
      2.972210,
      NULL,
      NULL,
      1,
      1.254868,
      1,
      1,
      0.460144,
      2.881088,
      2.315383,
      0,
      0,
      0.392482,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.717654,
      NULL,
      0,
      2,
      5.338548,
      0.359944,
      NULL,
      0.071592,
      1.024411,
      0,
      NULL,
      NULL,
      0,
      1.531855,
      1.792607,
      1,
      1,
      0.082980,
      NULL,
      NULL,
      0,
      NULL,
      1.153589,
      2,
      1,
      0,
      2,
      0.319610,
      NULL,
      1.739429,
      0.447100,
      0,
      1.658238,
      0,
      2,
      NULL,
      0.596050,
      NULL,
      9.083027,
      NULL,
      NULL,
      6,
      3,
      3,
      6,
      NULL,
      NULL,
      5.351902,
      2.753150,
      1.268801,
      0,
      6,
      1.306160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303379,
      0.180801,
      NULL,
      NULL,
      0,
      1.007254,
      NULL,
      0.380105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.178422,
      2,
      NULL,
      0.704259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.232871,
      NULL,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.864535,
      2,
      NULL,
      NULL,
      3.815938,
      0.728899,
      2,
      0.931219,
      0,
      NULL,
      0,
      1,
      1.771300,
      0,
      NULL,
      1.034999,
      0.834183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '33111',
      '',
      '',
      1.918279,
      '',
      NULL,
      NULL,
      3.953331,
      '1333',
      '',
      NULL,
      1.661001,
      4.516215,
      NULL,
      2.229857,
      3,
      2.398339,
      3,
      2,
      0.935100);
commit;
end;
/


