set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '23133202',
      9,
      36.852723,
      '0024310',
      210.191382,
      1,
      2.347480,
      1,
      '031324',
      NULL,
      ' 7- 0-1990',
      1,
      33,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.495603,
      3,
      0,
      1.564359,
      1,
      0,
      NULL,
      1.034599,
      0.094003,
      0.513764,
      NULL,
      NULL,
      0.777934,
      4,
      4,
      NULL,
      0,
      6.906898,
      1,
      NULL,
      1.837277,
      0.097386,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.613674,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0.292523,
      2,
      NULL,
      0,
      1.100359,
      0.962089,
      3,
      1,
      0.224092,
      1.502097,
      1.476483,
      NULL,
      0.647688,
      0.386604,
      9,
      NULL,
      1,
      1,
      0,
      0.769307,
      NULL,
      NULL,
      1.460371,
      NULL,
      NULL,
      0.678470,
      1.129582,
      NULL,
      0.797198,
      3.807108,
      0,
      0,
      1,
      1.548449,
      NULL,
      1.648268,
      0.402160,
      0,
      0.713055,
      1,
      NULL,
      1,
      NULL,
      0.662619,
      NULL,
      0.055757,
      2.997798,
      1,
      1.437634,
      0.104231,
      0.242555,
      0.302529,
      NULL,
      NULL,
      4,
      0.732539,
      5.510920,
      1.723288,
      NULL,
      NULL,
      1,
      NULL,
      6,
      5,
      NULL,
      2.366897,
      2.197008,
      1.418879,
      3,
      2.287048,
      NULL,
      0,
      5,
      1.426174,
      0.266232,
      1,
      4,
      0.682175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184589,
      0,
      1,
      0,
      0,
      0,
      1.703981,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.363991,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4,
      1,
      5.950885,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.535872,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.180726,
      0,
      0.761066,
      2.482885,
      NULL,
      1.280055,
      2,
      1,
      1.673937,
      1,
      1.026932,
      1,
      1.947496,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.666830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.800340,
      '34102',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '4342',
      NULL,
      NULL,
      5,
      1,
      0,
      0.831230,
      3.170598,
      0.711374,
      3.328426,
      0,
      2.259244);
commit;
end;
/


