set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '010',
      NULL,
      73,
      65.362586,
      '1210332',
      NULL,
      NULL,
      0,
      1,
      '202201',
      1.930579,
      ' 3-11-1979',
      12,
      7,
      NULL,
      NULL,
      0.283937,
      1,
      1.552323,
      1.245356,
      NULL,
      NULL,
      0.025424,
      1.582216,
      0,
      1.097182,
      2.569149,
      1.759821,
      NULL,
      1,
      1.165422,
      0.320847,
      NULL,
      1,
      4.651341,
      4.605243,
      0.380435,
      0.182748,
      3,
      0,
      4.022347,
      NULL,
      2.644013,
      0,
      NULL,
      NULL,
      1.507490,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      1.764811,
      NULL,
      0,
      2,
      1,
      2,
      0,
      1,
      0.924405,
      1.645841,
      NULL,
      3.195129,
      NULL,
      0.379114,
      0.886712,
      NULL,
      3.183162,
      NULL,
      0,
      NULL,
      1.049102,
      1.459683,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.725484,
      1,
      1,
      1,
      0,
      0.185088,
      0.400159,
      0.462769,
      0,
      1,
      NULL,
      1,
      0,
      0.876398,
      0.096707,
      NULL,
      0.309119,
      NULL,
      NULL,
      2,
      1.250203,
      0,
      0,
      1.076860,
      NULL,
      0.339638,
      2,
      4.923368,
      2.505964,
      2.075303,
      1,
      0,
      1.473812,
      NULL,
      0.380131,
      1.757004,
      NULL,
      3,
      5.491522,
      0,
      NULL,
      NULL,
      0.025841,
      NULL,
      NULL,
      4.384400,
      1.586882,
      NULL,
      1,
      1,
      0.223562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.351550,
      0,
      0.504982,
      0.389378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656833,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.755414,
      0.392738,
      1,
      NULL,
      2.767164,
      2,
      0.265925,
      NULL,
      NULL,
      NULL,
      1.931768,
      NULL,
      1.116073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.163392,
      NULL,
      0.537487,
      NULL,
      1.448296,
      0,
      1,
      1,
      0.948044,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1.726599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '11134',
      NULL,
      '',
      0.050203,
      '',
      NULL,
      '',
      3,
      '1212',
      '',
      '',
      0,
      1,
      1.740260,
      NULL,
      1,
      3,
      3.710699,
      1,
      1.694729);
commit;
end;
/


