set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '444',
      '40412101',
      30.935473,
      54,
      NULL,
      29.016220,
      6,
      NULL,
      1,
      '440104',
      0.231265,
      NULL,
      9,
      60.738043,
      0.084421,
      NULL,
      0,
      1.177791,
      0,
      NULL,
      0.211178,
      1.631540,
      0,
      0,
      1.567365,
      1,
      3.947753,
      0,
      1.961595,
      3.785735,
      0.391805,
      NULL,
      8.881796,
      1,
      3.534786,
      4,
      1,
      0,
      6.223989,
      0,
      1.969138,
      1.541703,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      0.559701,
      NULL,
      0.775095,
      1.988016,
      3,
      3.493651,
      1,
      1,
      NULL,
      1.435714,
      NULL,
      1.952350,
      NULL,
      4,
      2,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566336,
      NULL,
      NULL,
      1.734713,
      1.576172,
      1.161962,
      1,
      NULL,
      0.391957,
      0,
      1,
      1.326107,
      0,
      NULL,
      0,
      1.708244,
      NULL,
      NULL,
      0.433047,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      4.229467,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0.519080,
      1,
      1.504024,
      0,
      1,
      0,
      NULL,
      3,
      6,
      7.927042,
      4.035497,
      4.181421,
      2.196491,
      1,
      1,
      NULL,
      4.682844,
      NULL,
      0.503154,
      NULL,
      1,
      0.210725,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678457,
      1.561798,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.746133,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566680,
      3.631622,
      0.218420,
      NULL,
      NULL,
      NULL,
      1.571651,
      0.566714,
      NULL,
      4.881274,
      4,
      1,
      0.358191,
      NULL,
      NULL,
      NULL,
      1,
      0.548241,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.240339,
      NULL,
      NULL,
      2,
      1.122222,
      0,
      3.403934,
      NULL,
      1.749134,
      1.506372,
      0,
      0.700145,
      NULL,
      0.911343,
      NULL,
      1.458502,
      0,
      0.793582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '23302',
      '',
      '',
      1,
      '',
      '',
      '',
      0.976836,
      '4414',
      '',
      NULL,
      0,
      1.723346,
      2,
      1.389641,
      3.141470,
      2.638467,
      0,
      3.220207,
      5);
commit;
end;
/


