set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14100004',
      NULL,
      67,
      NULL,
      284.282052,
      5,
      0.828335,
      NULL,
      '221330',
      4,
      ' 1-26-1992',
      53,
      NULL,
      NULL,
      NULL,
      1.544653,
      0.415850,
      1.091386,
      0,
      1.495468,
      0,
      NULL,
      0,
      0,
      0,
      5.797178,
      1,
      0.915828,
      3.821635,
      1.314603,
      NULL,
      0.861941,
      0.025319,
      2,
      5,
      NULL,
      1.536149,
      1,
      1,
      NULL,
      0.277837,
      NULL,
      NULL,
      NULL,
      NULL,
      0.668284,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      3,
      1,
      3,
      0,
      0,
      0,
      NULL,
      3.339111,
      0,
      0.436875,
      2,
      0,
      0,
      1.955858,
      3.377527,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.765571,
      NULL,
      NULL,
      0.227489,
      1,
      1,
      NULL,
      4.924862,
      0,
      1.157174,
      0.751502,
      1,
      NULL,
      1,
      NULL,
      0,
      1.977734,
      0,
      0,
      1.469761,
      1,
      0.339044,
      NULL,
      1.710610,
      0.632945,
      NULL,
      0,
      0.233737,
      1.033438,
      3,
      1.411760,
      3,
      NULL,
      5.438318,
      2.745862,
      0.843319,
      0,
      5,
      NULL,
      3.880298,
      NULL,
      NULL,
      6,
      NULL,
      2.057957,
      2.869581,
      5,
      2.818304,
      0.219866,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      0.358586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209282,
      2,
      2,
      0.391756,
      1.696748,
      0.226509,
      1.583922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.791445,
      NULL,
      6,
      NULL,
      NULL,
      0.352730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.973082,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838345,
      0.740081,
      0.510314,
      5.095892,
      0,
      1,
      0.242832,
      NULL,
      NULL,
      NULL,
      0.343025,
      1,
      0.296399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647138,
      2,
      1.356145,
      NULL,
      0,
      1,
      1.156023,
      0,
      NULL,
      3.467528,
      NULL,
      NULL,
      1.677231,
      NULL,
      0,
      0.077769,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '02043',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      4,
      '1243',
      NULL,
      NULL,
      NULL,
      0.493383,
      2,
      2,
      2.849512,
      NULL,
      2.114043,
      NULL,
      1);
commit;
end;
/


