set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2433',
      '33243034',
      47,
      NULL,
      '1313144',
      NULL,
      NULL,
      NULL,
      2,
      '332121',
      3,
      NULL,
      48,
      40.329084,
      0.173492,
      NULL,
      1.178195,
      3.729451,
      0,
      NULL,
      0.903677,
      1.439490,
      0.071801,
      0,
      NULL,
      NULL,
      2,
      0.336006,
      1.590215,
      0.455966,
      0.053759,
      1,
      2.491483,
      NULL,
      2,
      1,
      0.945693,
      0,
      5.755415,
      1,
      NULL,
      3,
      NULL,
      0.453921,
      NULL,
      NULL,
      0.706672,
      NULL,
      NULL,
      9.980441,
      3,
      1.896141,
      2,
      2.480574,
      1.161638,
      2.043501,
      0.999490,
      3.454626,
      3.391035,
      0,
      0,
      NULL,
      3.027603,
      1.616610,
      1,
      1,
      1,
      0,
      6,
      0,
      2,
      7,
      1,
      2,
      1.341208,
      1.413143,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.185940,
      0,
      1,
      1,
      1.628222,
      1.036331,
      1.499034,
      NULL,
      0.248742,
      0.695760,
      0,
      1,
      NULL,
      NULL,
      0,
      0.518235,
      NULL,
      NULL,
      0.512790,
      3.443273,
      0.206935,
      0,
      2.142148,
      0.106730,
      NULL,
      1.811228,
      2.668588,
      0,
      1.802381,
      0.848652,
      NULL,
      NULL,
      4,
      0,
      2.894476,
      6,
      7.043179,
      3,
      1.883965,
      3,
      3.995249,
      NULL,
      2,
      4,
      1.547700,
      1,
      NULL,
      1.191759,
      0.120528,
      5,
      0.704039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576956,
      1,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.880617,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.950757,
      1,
      1.071971,
      NULL,
      NULL,
      NULL,
      1,
      2.658169,
      3.623044,
      NULL,
      NULL,
      0,
      3.274832,
      0.009877,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.315483,
      0.759001,
      NULL,
      1.631836,
      0.976781,
      1,
      0,
      1,
      3,
      0,
      0.485907,
      0.483594,
      NULL,
      0.304827,
      1,
      0.455124,
      0,
      1.606298,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '33103',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      4,
      NULL,
      '02041',
      '4001',
      0.218170,
      0,
      2.987751,
      3.629327,
      0,
      2,
      0.940903,
      1,
      2.094635);
commit;
end;
/


