set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      37,
      3.701275,
      '3420010',
      185.229183,
      0,
      NULL,
      NULL,
      '003111',
      3.231658,
      ' 3- 7-1979',
      13,
      11,
      1,
      NULL,
      0,
      1.732887,
      0,
      1.550036,
      NULL,
      0.787243,
      2,
      0,
      1.922459,
      0.679748,
      3.423315,
      0,
      1.321668,
      NULL,
      1,
      0,
      1,
      1.982138,
      2,
      NULL,
      NULL,
      1,
      1.009526,
      1,
      4.769273,
      3.165446,
      1.856907,
      1.649464,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.358684,
      NULL,
      1.753899,
      2.226917,
      1.302223,
      1,
      NULL,
      0.151195,
      NULL,
      NULL,
      0,
      0.745892,
      NULL,
      1.980764,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      1,
      1.348595,
      4.809429,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.400911,
      0.344407,
      1.669516,
      1.538295,
      NULL,
      0.495741,
      0,
      1,
      1,
      1,
      1,
      0.640557,
      0,
      0.067543,
      0.308489,
      1,
      NULL,
      0,
      1.187303,
      NULL,
      NULL,
      0.088501,
      1,
      1.558758,
      1,
      NULL,
      3,
      1.236661,
      1.487138,
      3,
      7.831041,
      1.513462,
      1.428664,
      0.709411,
      2.665230,
      1,
      3,
      2.071980,
      NULL,
      NULL,
      5,
      3.723098,
      NULL,
      5,
      NULL,
      4,
      NULL,
      0.863523,
      0,
      0,
      0,
      2,
      1.987305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828777,
      0.307201,
      NULL,
      NULL,
      1.440232,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.746991,
      3,
      1.325065,
      0.773992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993460,
      0.140374,
      NULL,
      NULL,
      NULL,
      0.122250,
      1.032619,
      NULL,
      5,
      5.902154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520024,
      4.497133,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      3.421515,
      0.116704,
      1.119683,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.192966,
      1,
      0.671937,
      NULL,
      NULL,
      0.300080,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.671254,
      '34131',
      '',
      '',
      0.782343,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '23112',
      NULL,
      3,
      3.743948,
      1,
      NULL,
      3.116007,
      2.599789,
      0,
      NULL,
      0);
commit;
end;
/


