set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4322',
      '02120304',
      63,
      62,
      '0101241',
      118,
      5,
      3,
      1,
      '411311',
      NULL,
      ' 5- 1-1994',
      6.361366,
      NULL,
      NULL,
      NULL,
      0.365173,
      NULL,
      0.219040,
      0.722387,
      1.909176,
      NULL,
      2,
      1,
      0,
      0.666218,
      5.140069,
      NULL,
      1.515993,
      2.252940,
      0.618584,
      2,
      3.987075,
      0,
      4,
      5.766200,
      0,
      0.211268,
      3,
      NULL,
      4.174196,
      1.496387,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.559524,
      0,
      NULL,
      2.475436,
      3.473483,
      0,
      NULL,
      3.984047,
      1.119205,
      NULL,
      3.961405,
      2,
      1,
      3,
      1,
      0.092076,
      3.562449,
      1,
      1.116254,
      4.491529,
      2,
      4,
      6,
      1,
      2,
      2.656172,
      0,
      NULL,
      NULL,
      0.223335,
      NULL,
      NULL,
      1.257714,
      0,
      0.221526,
      4.075459,
      1.356889,
      1.289226,
      1,
      0.619948,
      0,
      1.857375,
      NULL,
      1.039284,
      0.676430,
      1.119739,
      NULL,
      0,
      0.820898,
      NULL,
      1,
      NULL,
      1,
      2.986999,
      1.652223,
      2.089810,
      5.961718,
      1.463322,
      1.790831,
      1.574697,
      1,
      1.542143,
      0,
      1,
      0,
      0,
      4,
      NULL,
      0,
      3.535265,
      4,
      1.673443,
      7.645805,
      4,
      0,
      3,
      4.529797,
      5.579731,
      2.359883,
      2,
      1.927343,
      0.020966,
      NULL,
      2.203339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988154,
      0.281113,
      0,
      1,
      1.285140,
      1,
      NULL,
      1.126663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.028648,
      NULL,
      4.592863,
      NULL,
      2,
      1.345348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.895359,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.382340,
      1.352791,
      NULL,
      2,
      0,
      0.380632,
      0.707333,
      0,
      0,
      0.179009,
      1.907055,
      0,
      0,
      NULL,
      NULL,
      1.285327,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      '',
      0.294944,
      '',
      '',
      '',
      3.620610,
      '0424',
      '33433',
      '3132',
      0.986821,
      5,
      3.841448,
      2,
      1,
      3,
      2,
      NULL,
      2.972734);
commit;
end;
/


