set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0134',
      '34123213',
      87.823896,
      NULL,
      '1103103',
      350.014744,
      3,
      2.185804,
      3,
      '304044',
      2,
      NULL,
      57,
      31.934644,
      0,
      NULL,
      0.867319,
      3,
      1,
      0.647395,
      NULL,
      0.272464,
      NULL,
      1,
      1.320924,
      NULL,
      5,
      0.323104,
      1,
      0,
      1.760487,
      1,
      8.399609,
      0.517285,
      5,
      2.779595,
      7,
      0.469640,
      6.695323,
      0,
      NULL,
      2.521004,
      0.184224,
      0.389071,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.985445,
      2,
      NULL,
      3.133433,
      2,
      0.651966,
      NULL,
      NULL,
      2.926557,
      3.524546,
      NULL,
      NULL,
      2,
      2,
      3,
      0,
      NULL,
      0,
      0.836327,
      3.694547,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403351,
      NULL,
      1,
      5,
      4.973324,
      1,
      0.386223,
      1.229269,
      NULL,
      1,
      1,
      0,
      NULL,
      0.939411,
      0,
      0,
      1.275466,
      NULL,
      0,
      NULL,
      1.980708,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.165519,
      NULL,
      3.186355,
      1,
      1,
      0.597263,
      1.139479,
      3.110666,
      1.168878,
      0.276916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.705140,
      2.179584,
      5,
      11.909059,
      NULL,
      NULL,
      1.723558,
      0,
      8.233917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444985,
      1.951894,
      0,
      NULL,
      0,
      4.260918,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.318647,
      3.533468,
      2.553110,
      3.990117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.249028,
      NULL,
      2.322165,
      3.585217,
      1.009122,
      2,
      0.664199,
      NULL,
      NULL,
      NULL,
      1.530007,
      0,
      1.225594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3,
      3,
      2,
      0.125408,
      NULL,
      0,
      2,
      2.811287,
      1.808796,
      0,
      1.765149,
      1.293976,
      NULL,
      0,
      0,
      1.662503,
      0.602707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.843931,
      '30324',
      NULL,
      '',
      0,
      '',
      '',
      '',
      5,
      '1400',
      '23113',
      '0330',
      NULL,
      0,
      NULL,
      NULL,
      0.365820,
      3.761503,
      3,
      NULL,
      0);
commit;
end;
/


