set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '411',
      '10',
      NULL,
      15.797377,
      '2222103',
      23.269354,
      3,
      3,
      3,
      '201131',
      NULL,
      ' 4-15-1998',
      45,
      29.909167,
      NULL,
      NULL,
      1,
      1.606930,
      2,
      NULL,
      1.607035,
      1.597646,
      NULL,
      0.547299,
      NULL,
      1,
      2,
      0.084661,
      3,
      0.428834,
      1.871664,
      5.995918,
      3,
      NULL,
      0,
      1.903484,
      NULL,
      0.844377,
      0,
      0,
      0,
      1.036684,
      1,
      0.409366,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.091192,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.051397,
      0.389592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944770,
      1,
      0,
      0.475945,
      1.274686,
      0.653902,
      NULL,
      0.557448,
      1,
      NULL,
      1.529829,
      0.172154,
      0.712207,
      0.482265,
      0.288356,
      1,
      NULL,
      0.042598,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      3.847362,
      NULL,
      5.596988,
      0.100523,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      3.223445,
      NULL,
      2.664261,
      NULL,
      0.554837,
      NULL,
      3,
      NULL,
      4.172352,
      NULL,
      8,
      1,
      2,
      1.980879,
      0.650554,
      NULL,
      NULL,
      9.833779,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769960,
      0.155876,
      1,
      NULL,
      0,
      1.089504,
      1.875327,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.933146,
      NULL,
      NULL,
      3,
      3.197822,
      2.282870,
      3.378745,
      NULL,
      1,
      0.758598,
      3,
      7.298426,
      2.233170,
      1.221143,
      NULL,
      NULL,
      NULL,
      1.091336,
      1.951164,
      NULL,
      NULL,
      0.985383,
      2,
      0.936365,
      NULL,
      NULL,
      NULL,
      1,
      0.708777,
      0.810326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.835274,
      0,
      NULL,
      1,
      NULL,
      1.421031,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1.721059,
      0,
      0.440367,
      1.987690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.891900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.376530,
      '33044',
      '',
      '',
      1.632226,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


