set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      NULL,
      57,
      5.857981,
      '1443430',
      91.876193,
      6,
      0,
      0,
      '031314',
      NULL,
      ' 7-23-1985',
      52,
      13.945777,
      0.336420,
      NULL,
      0.414964,
      1.702579,
      0.895942,
      1,
      0.667337,
      1,
      1.884074,
      0.730112,
      1.358404,
      0.610661,
      5.382111,
      1,
      3.907990,
      1,
      5,
      2,
      0.660976,
      0.726829,
      0,
      0.923318,
      1.298798,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.124804,
      NULL,
      NULL,
      5,
      0.033384,
      0.744378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      3.237093,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.930454,
      0,
      0,
      0,
      NULL,
      NULL,
      1.609138,
      0.925497,
      1,
      1.709999,
      1.489101,
      0.940293,
      1.989222,
      0.330005,
      1.911618,
      0.862260,
      0.154390,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.611608,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464934,
      0,
      1,
      NULL,
      0,
      1,
      5.382151,
      3,
      6.201857,
      NULL,
      0.535186,
      3,
      NULL,
      1.272396,
      3.675581,
      1,
      0,
      NULL,
      NULL,
      4,
      0.592825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.430550,
      NULL,
      1.948028,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.288638,
      2.249627,
      NULL,
      1,
      1.726012,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.673850,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.614434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153705,
      3.337356,
      0.259739,
      0,
      0,
      0.073638,
      0.870385,
      1,
      NULL,
      1,
      1,
      1.432401,
      1.028311,
      0,
      0.797787,
      0.632901,
      NULL,
      1,
      0,
      1.373465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.519509,
      NULL,
      0.375330,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0);
commit;
end;
/


