set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      '33213141',
      50,
      23.193335,
      '2300134',
      61.787992,
      NULL,
      2.332615,
      3,
      '130202',
      3.213550,
      ' 3- 9-1974',
      2,
      5.698851,
      0.643724,
      NULL,
      1,
      NULL,
      1.587193,
      NULL,
      NULL,
      NULL,
      0.797340,
      3.281716,
      0.490691,
      0,
      1,
      1,
      1,
      0.772216,
      NULL,
      NULL,
      NULL,
      1.898045,
      NULL,
      0.959308,
      1,
      0.627666,
      0,
      0,
      0,
      1.234426,
      1,
      0.898086,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.550809,
      1.846627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.816904,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1.205177,
      0,
      0,
      0.670978,
      1.903550,
      1,
      NULL,
      0,
      1.604129,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.047386,
      0,
      NULL,
      1,
      1.451570,
      4.224775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.405420,
      0.344396,
      NULL,
      3.313259,
      3,
      5,
      8.797560,
      3.846953,
      NULL,
      8,
      1,
      1.407387,
      8,
      NULL,
      0.835075,
      NULL,
      NULL,
      7,
      1.027532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578490,
      0.800282,
      2,
      1,
      1.148640,
      0,
      1,
      1.303033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8.906689,
      NULL,
      2,
      1.406004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.782024,
      0,
      4.047781,
      3,
      1.126707,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      3.293244,
      0,
      0.078605,
      1.748389,
      NULL,
      3.754048,
      1,
      0.426322,
      NULL,
      0.413192,
      0.746168,
      NULL,
      1.163168,
      1.261910,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.065432,
      '02303',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3.345661,
      '40004',
      '',
      '',
      3,
      NULL,
      3.621296,
      0.285364,
      1,
      0.452352,
      1,
      NULL,
      2);
commit;
end;
/


