set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '240',
      '42143331',
      NULL,
      44,
      '4420441',
      34.332943,
      4,
      3,
      NULL,
      '321400',
      NULL,
      NULL,
      NULL,
      NULL,
      0.250975,
      NULL,
      1,
      0.827631,
      2,
      1,
      1,
      0.257990,
      1.007012,
      0,
      NULL,
      1,
      1.158526,
      NULL,
      0,
      0.691867,
      1.660253,
      0.443007,
      1.680212,
      NULL,
      1,
      1,
      0,
      NULL,
      0.452360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1.609281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.779597,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438932,
      0,
      1.112723,
      1,
      0.957625,
      0.723398,
      0,
      1.313961,
      1,
      0,
      NULL,
      0.708310,
      1.785146,
      NULL,
      0,
      1.424047,
      NULL,
      1,
      0.906895,
      NULL,
      0.382654,
      1,
      0,
      0.940195,
      3,
      0.760409,
      0,
      1.711939,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971972,
      1.148745,
      0,
      0.124690,
      NULL,
      0.181760,
      0.667090,
      0.774784,
      4,
      2.873137,
      NULL,
      8,
      NULL,
      1,
      1,
      0.847473,
      0.284254,
      NULL,
      NULL,
      9,
      1.946168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.486852,
      1,
      NULL,
      0.370963,
      1.469887,
      0.082696,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.844114,
      NULL,
      0,
      1,
      1,
      NULL,
      4,
      2.527269,
      1,
      NULL,
      NULL,
      NULL,
      1.683916,
      NULL,
      1.191540,
      0.161534,
      0,
      0,
      0.871790,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345743,
      NULL,
      2,
      1.874717,
      3,
      0.544724,
      3.774155,
      0,
      0.168576,
      1.569138,
      NULL,
      0,
      NULL,
      0.483896,
      NULL,
      0,
      0,
      1.782957,
      0.166009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.009791,
      '31433',
      '',
      '',
      1.549401,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      3.652049,
      NULL,
      1,
      2,
      2.206414,
      2.761207,
      0,
      1,
      3.697885);
commit;
end;
/


