set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400870';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      46,
      NULL,
      '2314330',
      NULL,
      2,
      2.867417,
      2,
      '432003',
      1.181623,
      ' 8-29-1997',
      21,
      10.434264,
      0,
      NULL,
      NULL,
      1,
      3.514301,
      0,
      0,
      NULL,
      1.091780,
      NULL,
      1,
      0,
      1.050551,
      0.452710,
      3,
      1.627420,
      0.469354,
      0.482490,
      4,
      0.716532,
      NULL,
      1.824390,
      NULL,
      0,
      0.563343,
      1,
      0.749015,
      3.580613,
      0.161137,
      0.148212,
      NULL,
      NULL,
      1.487579,
      NULL,
      NULL,
      0,
      0.663949,
      1.308761,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575469,
      0.363300,
      1,
      1.104885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174682,
      NULL,
      NULL,
      0,
      0.711245,
      0.711860,
      0,
      1.107588,
      NULL,
      1,
      NULL,
      1.098504,
      0,
      1,
      0,
      0.918787,
      NULL,
      NULL,
      1.827042,
      NULL,
      0,
      1,
      1,
      NULL,
      3,
      0.812829,
      NULL,
      3.027721,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      4.369837,
      2,
      2,
      7,
      5,
      5.783953,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.373567,
      NULL,
      NULL,
      8,
      1.725528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665001,
      0,
      2,
      1,
      1.138614,
      1,
      1.304861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477135,
      NULL,
      2.425610,
      2.126515,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.009068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989067,
      NULL,
      2.619657,
      NULL,
      NULL,
      0.592540,
      0.750211,
      NULL,
      0.428819,
      NULL,
      NULL,
      NULL,
      1,
      0.697324,
      0.850569,
      NULL,
      1,
      0.897497,
      0.808237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.465686,
      '03123',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.564287,
      '31142',
      '',
      '',
      NULL,
      2,
      0,
      0.443599,
      1,
      1.127736,
      0.809720,
      3,
      2.643959);
commit;
end;
/


