set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '03',
      44,
      25.373431,
      '2333300',
      11.664902,
      0,
      3,
      3,
      '211444',
      4.866206,
      ' 3-16-1998',
      NULL,
      42.992342,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1.572655,
      1.295244,
      1,
      1.188772,
      2,
      1,
      0,
      0,
      0,
      1,
      1,
      0.599190,
      1,
      NULL,
      0,
      1,
      0.319877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.963090,
      NULL,
      0,
      2,
      1,
      1.887983,
      NULL,
      NULL,
      0.058347,
      NULL,
      NULL,
      3.390373,
      NULL,
      6.576622,
      NULL,
      9,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.899251,
      NULL,
      0.979482,
      2,
      1,
      0,
      1.180668,
      0.273294,
      1,
      NULL,
      NULL,
      5,
      4,
      0.188250,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7,
      5.406583,
      1,
      3.230382,
      5,
      NULL,
      6.422352,
      1,
      6,
      5,
      NULL,
      6,
      9.025981,
      9,
      6.262580,
      5,
      0,
      0,
      0,
      0,
      4.628486,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424381,
      0.880425,
      1,
      0,
      NULL,
      3,
      0.352304,
      0.673190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.175428,
      2.425770,
      1,
      NULL,
      NULL,
      NULL,
      0.701420,
      0.326537,
      1.387088,
      2.930645,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.184615,
      0.877993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081985,
      NULL,
      1.025777,
      1.986224,
      1,
      0.782325,
      0,
      3,
      0.538084,
      1.689052,
      3.074542,
      1.832370,
      NULL,
      0,
      0,
      1,
      0.298885,
      NULL,
      0.733959,
      1.213755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '01033',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.738079,
      NULL,
      '',
      NULL,
      1.692250,
      1,
      2.082141,
      NULL,
      1,
      0,
      3,
      0.423257,
      1);
commit;
end;
/


