set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '013',
      '04221142',
      13,
      NULL,
      NULL,
      62.965484,
      3,
      1.281747,
      2,
      '311223',
      6,
      '10-23-2001',
      1.859868,
      41.163548,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861946,
      0.278624,
      1.051238,
      NULL,
      0.909051,
      1.423346,
      0.446905,
      0,
      2.553180,
      0,
      1,
      NULL,
      1.379083,
      0,
      0,
      1.672561,
      0.176823,
      1.994555,
      1,
      0,
      NULL,
      1,
      4.124123,
      3,
      1.641458,
      0,
      NULL,
      NULL,
      0.678731,
      NULL,
      NULL,
      4,
      2,
      3.230333,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.505479,
      1.487386,
      3.947379,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1.930085,
      NULL,
      NULL,
      1,
      0,
      1.108302,
      1.080520,
      6,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      5.499726,
      0,
      2,
      1,
      0.048293,
      1.664935,
      NULL,
      1.876225,
      NULL,
      0,
      0.537450,
      1,
      1.520547,
      1.045168,
      1,
      9.437811,
      1.539727,
      NULL,
      0,
      NULL,
      0.423573,
      1.736180,
      1.025970,
      NULL,
      5.257534,
      1.399605,
      1.693851,
      NULL,
      2.010107,
      6.600154,
      4,
      3.319579,
      NULL,
      8.673452,
      NULL,
      0.872002,
      2.747194,
      1.502621,
      NULL,
      NULL,
      4,
      0.987719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0.590242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680857,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.795895,
      1.498150,
      NULL,
      NULL,
      NULL,
      4.246048,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.563880,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.004221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114174,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.031843,
      2.537620,
      2,
      3,
      2,
      NULL,
      1,
      1.974254,
      NULL,
      1,
      0.056489,
      NULL,
      0,
      1.462057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '24422',
      '',
      '',
      0.883904,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      2.175182,
      3,
      3.095444,
      3,
      3.210458,
      1.763955);
commit;
end;
/


