set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '432',
      '12340230',
      NULL,
      33,
      '0311044',
      14.909379,
      NULL,
      NULL,
      1,
      '211403',
      NULL,
      NULL,
      NULL,
      30.262467,
      1.756720,
      NULL,
      1.745032,
      1,
      1,
      1,
      1,
      1.015672,
      NULL,
      1,
      0,
      NULL,
      3.710542,
      0,
      1.228846,
      1.655319,
      1.868731,
      1.453637,
      2,
      1.220405,
      0,
      1.691937,
      1.742142,
      1.072285,
      2.287833,
      3,
      NULL,
      1.734296,
      2.999692,
      0,
      NULL,
      NULL,
      0.830564,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.632378,
      0.968026,
      0,
      0,
      1.026568,
      3,
      1,
      0,
      1,
      1.555930,
      2,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      NULL,
      1.261533,
      3.483064,
      0,
      NULL,
      2,
      1.841782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0,
      4,
      0,
      1.695389,
      0,
      NULL,
      0.596517,
      NULL,
      2.863191,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      1,
      3.255711,
      NULL,
      5.838338,
      1,
      3.838030,
      6,
      2.414145,
      NULL,
      6,
      2.613724,
      5.584477,
      NULL,
      6.238131,
      2,
      5,
      10.326457,
      5.341300,
      3.468720,
      5.544971,
      7.242716,
      3.024615,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.343669,
      NULL,
      0,
      0.146599,
      0.809400,
      1.203512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352734,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.020457,
      0.201092,
      0,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.168494,
      NULL,
      0,
      0,
      1.832973,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122099,
      1.356393,
      0.377719,
      0.441488,
      1,
      2,
      NULL,
      3,
      NULL,
      NULL,
      1.788783,
      1,
      0,
      1,
      NULL,
      0.291450,
      0,
      1,
      0.109588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.929302,
      '12442',
      '',
      '',
      0.803226,
      '',
      '',
      '',
      0,
      '2240',
      '',
      NULL,
      1,
      2.179394,
      2.280404,
      3.569655,
      0.689259,
      3,
      0,
      3,
      NULL);
commit;
end;
/


