set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '001',
      '03324223',
      40,
      59.462427,
      '1140210',
      91.266460,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      21,
      47.251647,
      0,
      NULL,
      NULL,
      0,
      1.284628,
      NULL,
      NULL,
      NULL,
      0,
      1.050269,
      0,
      0,
      0.224685,
      1,
      NULL,
      1.060293,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.247629,
      1,
      0.892369,
      0,
      NULL,
      3.583664,
      1.504875,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      1.788109,
      1.093862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017084,
      0,
      1.144284,
      2,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.389628,
      4.156997,
      NULL,
      3.018973,
      7.127393,
      0,
      0.383735,
      0.421647,
      1.612483,
      1.954350,
      1.306347,
      3.714155,
      0.588656,
      NULL,
      0,
      0.956889,
      1.690376,
      0,
      1,
      NULL,
      0.287820,
      NULL,
      2,
      0,
      NULL,
      1,
      0,
      0.328713,
      5,
      0,
      3,
      0.630735,
      0.068673,
      NULL,
      2,
      3,
      5.679345,
      1.168863,
      6.037588,
      NULL,
      NULL,
      5.710862,
      0,
      4.755985,
      6.450869,
      NULL,
      NULL,
      4.525464,
      3,
      0.403252,
      0,
      4,
      0.961837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.442148,
      1,
      1,
      0,
      0,
      0.798737,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655704,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.715089,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036686,
      NULL,
      NULL,
      NULL,
      2,
      0.714763,
      NULL,
      NULL,
      NULL,
      0,
      3.025570,
      0.127132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.142182,
      0.581720,
      NULL,
      1.360874,
      NULL,
      3,
      0,
      1.583940,
      NULL,
      3.987863,
      1.667743,
      0.348729,
      1,
      1,
      NULL,
      NULL,
      1.459920,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.409401,
      '43001',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.243976,
      '3430',
      '',
      '',
      1.354096,
      3,
      2.046499,
      0.101233,
      1.722485,
      2.632847,
      2.595450,
      NULL,
      2.380296);
commit;
end;
/


