set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      '44132042',
      55,
      1,
      '0421043',
      127,
      1,
      NULL,
      0,
      '010123',
      0,
      ' 8- 1-1978',
      29,
      26,
      1,
      NULL,
      NULL,
      1.148380,
      2.315057,
      0,
      1,
      2,
      0.874652,
      0.444533,
      0.692658,
      NULL,
      5.886419,
      0.494801,
      NULL,
      0.241407,
      NULL,
      0.986050,
      5,
      1,
      1,
      NULL,
      2.408025,
      0,
      4.378962,
      0,
      0.763107,
      1.305616,
      2,
      0.652130,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.059430,
      2.369178,
      0.419448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.775146,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.391101,
      2.491872,
      7,
      0,
      0.257244,
      0.587076,
      NULL,
      NULL,
      1.674910,
      NULL,
      1.850841,
      NULL,
      1.222684,
      1.318220,
      1,
      1.592996,
      0.203792,
      NULL,
      0,
      1.853990,
      1.198587,
      1,
      1,
      1.349825,
      1.119370,
      NULL,
      2.675396,
      1,
      NULL,
      3.914203,
      6,
      0,
      6,
      2.417507,
      5,
      3,
      1.868625,
      NULL,
      3.035428,
      NULL,
      1,
      2,
      9,
      NULL,
      3,
      NULL,
      2.888852,
      0,
      1,
      2.333390,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.552094,
      0.715976,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679926,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721397,
      3,
      2,
      1.805148,
      1.767353,
      2.013821,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.234746,
      1.999920,
      NULL,
      1,
      1,
      0.973431,
      NULL,
      NULL,
      NULL,
      0.290230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      3.512140,
      0,
      0.762680,
      0,
      1.862168,
      1.180061,
      1,
      NULL,
      0,
      0.404796,
      0,
      NULL,
      1.132986,
      1.905109,
      1.399444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.483297,
      NULL,
      '',
      '',
      0.686128,
      NULL,
      '',
      '',
      0,
      '1112',
      '',
      '',
      4.586522,
      1,
      0,
      3.717222,
      NULL,
      3,
      2,
      2,
      1.974036);
commit;
end;
/


