set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10444103',
      1.084679,
      29.067347,
      NULL,
      71,
      3,
      3,
      NULL,
      '311331',
      2,
      ' 4- 5-1990',
      27,
      NULL,
      1,
      NULL,
      1.663853,
      1,
      2.429870,
      1,
      1.924927,
      2.662095,
      1.484153,
      1,
      1,
      0,
      0.353631,
      NULL,
      0.109227,
      0.584100,
      1.178589,
      1.734921,
      NULL,
      0,
      3.202104,
      NULL,
      3,
      NULL,
      3.748925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832899,
      2,
      NULL,
      1.925433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471187,
      0,
      2.365326,
      0.535547,
      0,
      2,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      6.420338,
      1,
      NULL,
      0,
      0.812822,
      NULL,
      1.317957,
      1,
      0,
      NULL,
      NULL,
      1,
      1.861274,
      0,
      NULL,
      0.314868,
      1,
      NULL,
      0.012482,
      NULL,
      NULL,
      NULL,
      5.393779,
      1,
      0.121282,
      0,
      NULL,
      1.382541,
      4.980855,
      5,
      NULL,
      NULL,
      3.411329,
      1,
      2.630489,
      6,
      4.346673,
      NULL,
      0.762514,
      NULL,
      NULL,
      NULL,
      1.924879,
      0,
      NULL,
      NULL,
      1,
      0.226437,
      NULL,
      3.809212,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560184,
      NULL,
      NULL,
      NULL,
      NULL,
      3.710000,
      NULL,
      1.768232,
      NULL,
      1.508209,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.593059,
      1,
      0,
      4,
      0,
      0,
      1.930079,
      NULL,
      NULL,
      NULL,
      0.112831,
      1.507591,
      0.859542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.585906,
      NULL,
      3.613950,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.395990,
      0,
      1.746729,
      0,
      1,
      1.374291,
      0.951761,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '12302',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.634550,
      '4332',
      '',
      '',
      2.038685,
      0,
      0,
      1,
      1,
      0.021301,
      1,
      1.392112,
      3);
commit;
end;
/


