set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9635525';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3310',
      '30333310',
      29,
      NULL,
      '2142110',
      22,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-1985',
      35.275910,
      41,
      1,
      NULL,
      0,
      0,
      0.235119,
      0,
      0.884701,
      NULL,
      1,
      NULL,
      1,
      0.476241,
      NULL,
      0.100163,
      1.696901,
      1.457295,
      0,
      0.478846,
      2,
      1.587994,
      2,
      NULL,
      2,
      2,
      0.763313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.085243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415024,
      0,
      3,
      6,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.705920,
      NULL,
      NULL,
      0,
      4.603006,
      3.089659,
      2.247210,
      3,
      1,
      1.682645,
      NULL,
      1,
      1.240344,
      0,
      1.011084,
      1.772822,
      0.494663,
      0,
      NULL,
      1,
      1.599517,
      0.686269,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      1.094725,
      1.159547,
      NULL,
      0.498969,
      5,
      6,
      4.048747,
      5.773993,
      6.286631,
      2.180832,
      5,
      4.762444,
      NULL,
      6,
      NULL,
      1,
      NULL,
      7.910180,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.780114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1.856910,
      0.882874,
      1,
      1.459779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.076758,
      1.907472,
      0,
      NULL,
      NULL,
      NULL,
      0.676356,
      NULL,
      0.837426,
      NULL,
      1,
      1,
      0.779859,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137983,
      0.670970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.314044,
      1.797323,
      3,
      3,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      0.743246,
      0.934217,
      0.615920,
      1.703909,
      NULL,
      1.643301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.388024,
      '31042',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.415654,
      '0330',
      NULL,
      '',
      4,
      3.137223,
      2.995710,
      2.789953,
      3,
      1.295125,
      3.937956,
      0,
      0);
commit;
end;
/


