set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '103',
      '02',
      1.248423,
      21,
      NULL,
      15,
      NULL,
      0.191973,
      NULL,
      NULL,
      3.809244,
      ' 2- 9-2003',
      NULL,
      63.030896,
      1.978895,
      NULL,
      1.779669,
      NULL,
      1.281655,
      0.500669,
      1.917853,
      0.980949,
      1,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.638478,
      0.691749,
      0.017717,
      0,
      1.475403,
      6,
      NULL,
      NULL,
      1,
      0.618495,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5.032761,
      1.856309,
      1.109877,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673438,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.887612,
      0.486638,
      0,
      NULL,
      1.575579,
      0.705931,
      1.447909,
      1,
      0.048917,
      1.962821,
      0.650887,
      0,
      NULL,
      1.333024,
      0.898261,
      1.597282,
      NULL,
      NULL,
      6.655087,
      5,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1.902267,
      NULL,
      NULL,
      5,
      4.619223,
      NULL,
      NULL,
      0,
      2.899256,
      3,
      7.421558,
      3.188400,
      3,
      0.229203,
      1.594850,
      NULL,
      7,
      4.384696,
      4,
      NULL,
      0,
      1.184637,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.653471,
      1,
      0,
      1,
      0,
      1.379776,
      0.113817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.576692,
      NULL,
      NULL,
      2,
      0,
      2.424952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.667498,
      3.649501,
      2.330487,
      1.791923,
      0,
      1,
      0.310677,
      NULL,
      7,
      5.839789,
      0,
      6.518900,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.994502,
      3,
      NULL,
      6.993913,
      8.056983,
      0,
      0.334316,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      0.062360,
      1.723093,
      1,
      1,
      0.784348,
      0.404810,
      0,
      NULL,
      NULL,
      0.435919,
      0.483992,
      0.125336,
      0,
      1.659199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.375993,
      NULL,
      '',
      '',
      0.714798,
      '',
      '',
      '',
      3,
      '3144',
      '',
      '',
      2.843369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


