set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3375557';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1202',
      '41132300',
      48.288763,
      29.347030,
      NULL,
      13,
      6,
      1.970732,
      3,
      '221340',
      2,
      ' 6- 7-1976',
      33.550388,
      1,
      0.861251,
      NULL,
      0.685857,
      0.922588,
      2,
      NULL,
      1,
      1,
      0,
      1.310052,
      1,
      0.751090,
      0.040888,
      NULL,
      1.494021,
      1,
      1,
      1.372369,
      5.067828,
      0.190934,
      1,
      1.981162,
      0.639992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.526019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.623404,
      1.263003,
      3.283073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566019,
      NULL,
      0.969020,
      0.776074,
      0,
      1.552496,
      1,
      NULL,
      1.556795,
      0.316384,
      1.447042,
      0,
      0,
      1.093846,
      0.421349,
      1.491265,
      NULL,
      1,
      5,
      NULL,
      0,
      1,
      0,
      5,
      1,
      4.185220,
      NULL,
      1,
      2.293587,
      4.190134,
      3.987971,
      2,
      1,
      2,
      0.430353,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0,
      8,
      3,
      0,
      2,
      0.377329,
      NULL,
      NULL,
      1.644539,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108127,
      0.693022,
      1,
      1,
      NULL,
      0.387745,
      1.624135,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.993501,
      2,
      0.236830,
      1.528391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.383626,
      NULL,
      1.733884,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187178,
      3.923407,
      1,
      2,
      0,
      3.580443,
      NULL,
      NULL,
      NULL,
      1.576638,
      4.417064,
      1.245312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.170121,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.636366,
      1.207827,
      NULL,
      1.765523,
      1,
      0.882051,
      0.941249,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.095751,
      '02031',
      NULL,
      NULL,
      1.822003,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1.768637,
      7.734239,
      2.268628,
      0,
      3,
      2,
      2,
      5.178334,
      0.312846);
commit;
end;
/


