set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9763902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '13130302',
      15.154439,
      NULL,
      '2022033',
      10,
      4,
      2,
      0,
      NULL,
      2.680224,
      ' 4-27-1987',
      157,
      26.990160,
      1.365938,
      NULL,
      NULL,
      0.597118,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1.475444,
      0.429494,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.540526,
      0,
      1,
      1.715773,
      0,
      0.187794,
      0.519113,
      0,
      1.224830,
      NULL,
      NULL,
      0,
      0.189513,
      0,
      2.043173,
      0.536689,
      1.994178,
      0,
      1.092237,
      0,
      3,
      NULL,
      NULL,
      1.222275,
      0,
      1.997236,
      NULL,
      0,
      3,
      1,
      1.171675,
      3.171004,
      1.326794,
      0.468487,
      0.888541,
      NULL,
      2.453799,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1.705562,
      0.387684,
      1.136907,
      NULL,
      1.243937,
      NULL,
      0,
      1.482841,
      1.249795,
      1,
      1.868605,
      NULL,
      1,
      1,
      1,
      1.294340,
      0.014450,
      1.770713,
      1,
      1.360626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.347975,
      0.578212,
      0,
      0,
      5,
      0,
      7.213095,
      NULL,
      NULL,
      NULL,
      0,
      7,
      2.054774,
      NULL,
      6,
      7.023975,
      0,
      6.828640,
      7,
      NULL,
      3,
      2,
      NULL,
      0.435233,
      NULL,
      4.367390,
      3.401442,
      1.668180,
      1.085084,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.109542,
      1,
      0,
      1,
      0.119374,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.520166,
      NULL,
      8.909832,
      1.958340,
      NULL,
      1.840779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.674165,
      0,
      0,
      3.645799,
      0.352663,
      NULL,
      0,
      3.974689,
      7,
      NULL,
      2,
      0,
      1.083237,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.638529,
      3.519136,
      0,
      4.011969,
      NULL,
      1.745570,
      1,
      1,
      NULL,
      3,
      NULL,
      2.534474,
      0.015198,
      2.421946,
      NULL,
      0,
      0.259996,
      2.083920,
      NULL,
      0.225028,
      1.061481,
      0,
      1.496771,
      1,
      0,
      1.446181,
      0.142467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.033342,
      '42232',
      '',
      '',
      1.622703,
      '',
      '',
      NULL,
      1.386175,
      '',
      '',
      '',
      3.060720,
      0,
      NULL,
      1.664235,
      0.070027,
      NULL,
      0.660530,
      1,
      3);
commit;
end;
/


