set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9763902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      '24344304',
      57.229046,
      11.052043,
      NULL,
      2,
      3,
      0.833744,
      1,
      NULL,
      4,
      ' 5-23-1999',
      42.482973,
      133,
      0.314834,
      NULL,
      3,
      1.856123,
      2.097559,
      NULL,
      1.085154,
      3.766173,
      0.331447,
      3,
      2,
      NULL,
      1.382032,
      0,
      NULL,
      NULL,
      0.408965,
      3,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      2.538584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345169,
      1.900561,
      0.758116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.773813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.902643,
      NULL,
      1,
      0.902234,
      0,
      1,
      1,
      1.312611,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.344045,
      0,
      1.887103,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      5.742560,
      NULL,
      5.226849,
      NULL,
      1.210145,
      NULL,
      1.774554,
      1.679625,
      NULL,
      0.416186,
      1,
      4.731323,
      5,
      0,
      3.137151,
      2,
      0.373675,
      NULL,
      4,
      1.448854,
      3,
      NULL,
      0.846052,
      NULL,
      NULL,
      NULL,
      1.481469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579526,
      0,
      1,
      0,
      0.676956,
      NULL,
      1.885618,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.161030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565247,
      1.932956,
      NULL,
      1.316783,
      2.916334,
      1,
      1.912091,
      0,
      0,
      1.074965,
      1.271474,
      1,
      1.092067,
      0.107815,
      1,
      0,
      0,
      0.531975,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.062632,
      '21032',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.418591,
      '',
      '',
      NULL,
      3.000225,
      1,
      2.782371,
      3.392594,
      1.461509,
      1,
      NULL,
      1.382777,
      1);
commit;
end;
/


