set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '1312000',
      8.051201,
      4,
      NULL,
      NULL,
      '432334',
      NULL,
      ' 6-29-2003',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.358750,
      1.219359,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      3.346578,
      NULL,
      1.682745,
      0.040488,
      0.016562,
      1.669893,
      4,
      0.679983,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      2.422448,
      1.944063,
      0.839314,
      1,
      NULL,
      NULL,
      1.574221,
      NULL,
      NULL,
      NULL,
      1.219399,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.409028,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      3,
      4,
      7.815538,
      0,
      0.891941,
      0.178678,
      3,
      6.902009,
      1.645374,
      7.427131,
      1.445860,
      1.132216,
      NULL,
      1.855705,
      0,
      NULL,
      1,
      1,
      6,
      NULL,
      0.885716,
      1.302462,
      2,
      0.842674,
      NULL,
      1,
      1,
      4,
      1,
      NULL,
      5.371893,
      2,
      0,
      11,
      2.040241,
      8,
      6.115508,
      1.369815,
      5.141207,
      2.370346,
      3,
      7.463711,
      9,
      2,
      3.510346,
      0.497027,
      0,
      4.139089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.699974,
      0,
      1,
      0.042200,
      NULL,
      NULL,
      1.020453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012126,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.090543,
      3.219450,
      0.372087,
      NULL,
      NULL,
      NULL,
      3.386413,
      0.886630,
      1.802654,
      7.652082,
      3.550101,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.718779,
      3.529280,
      1.296055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236817,
      NULL,
      2.235902,
      2,
      0.674509,
      0,
      3,
      3.451742,
      1.196989,
      1,
      NULL,
      1.294088,
      0.562434,
      0,
      0,
      NULL,
      0.378583,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.387049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.055044,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.576055,
      0,
      1.109832,
      NULL,
      0,
      NULL,
      '',
      '',
      1.885193,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


