set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '2212023',
      15,
      5,
      1,
      0,
      NULL,
      1,
      NULL,
      9.816850,
      NULL,
      1.296451,
      NULL,
      3,
      2.927152,
      1,
      0.289420,
      1.731183,
      0.368420,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0.327086,
      0,
      0.808640,
      0,
      5.862039,
      1.910048,
      3,
      0.839184,
      NULL,
      0,
      5.731009,
      3,
      2.218879,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.223125,
      1.064909,
      NULL,
      0.211362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268573,
      0.773307,
      1,
      0,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.255927,
      0,
      0,
      7,
      6,
      NULL,
      NULL,
      1,
      NULL,
      1.381312,
      0.196910,
      7.779148,
      1.280767,
      0,
      1.925178,
      1,
      0.689175,
      NULL,
      0,
      8,
      5,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      0.028292,
      0,
      8.879196,
      0,
      2.394618,
      7.515906,
      3.725434,
      7,
      0.361427,
      3,
      2,
      1,
      1.659621,
      5.320924,
      8,
      5.854016,
      0,
      0,
      NULL,
      1.907723,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207611,
      1.102230,
      1,
      2,
      1,
      7.447653,
      NULL,
      1.536244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160624,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.370919,
      1.653965,
      NULL,
      NULL,
      NULL,
      1.986872,
      NULL,
      1.423686,
      5.387385,
      4.227678,
      0,
      3.189007,
      1.327994,
      NULL,
      NULL,
      0.942687,
      7.645806,
      1.322353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.047878,
      2,
      1.764387,
      0,
      1,
      1.131417,
      NULL,
      0.869916,
      1,
      3,
      0.408479,
      1,
      1,
      NULL,
      1.257689,
      0.338070,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.572767,
      NULL,
      0,
      NULL,
      NULL,
      1.660684,
      NULL,
      0,
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.049766,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


