set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '3442440',
      2,
      5,
      3.750047,
      0,
      '201331',
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      4,
      0.660155,
      0,
      0.935807,
      3.902932,
      1.776667,
      1,
      1,
      1.105619,
      0,
      1.542178,
      1.642720,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.632573,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1.912138,
      NULL,
      NULL,
      1.684516,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.686989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458736,
      2.713770,
      0.457372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.821929,
      3.732430,
      1,
      3.500532,
      6.410326,
      NULL,
      1.754214,
      0,
      NULL,
      0,
      0,
      NULL,
      5.425111,
      0.980969,
      0,
      NULL,
      1.324427,
      0,
      NULL,
      1.439959,
      1.358055,
      NULL,
      7.148016,
      7.640063,
      1.620031,
      0,
      1.118134,
      3.570638,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.100394,
      2.892283,
      NULL,
      NULL,
      1,
      7,
      0,
      4,
      8.441991,
      5.604878,
      6.412409,
      8,
      3.529356,
      2,
      1,
      1,
      5,
      0.040361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224293,
      NULL,
      1,
      1,
      0,
      4,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.470084,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.592915,
      0.848972,
      NULL,
      NULL,
      NULL,
      7.130508,
      0,
      0,
      2,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.624909,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.124564,
      1.205230,
      1,
      3.536857,
      1.545814,
      0.849491,
      3.684898,
      2.502600,
      2.395690,
      1.384869,
      1,
      0,
      1.773515,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '04411',
      '',
      NULL,
      1.552897,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


