set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '3120422',
      23,
      1,
      1,
      0,
      '003114',
      3,
      NULL,
      26.005290,
      NULL,
      0,
      NULL,
      1,
      2,
      1.638446,
      0,
      1,
      1,
      1,
      NULL,
      0.123347,
      1.016890,
      2,
      0,
      0,
      1,
      2,
      0,
      5.804495,
      NULL,
      0.286777,
      0.631983,
      0.947704,
      0.424759,
      4,
      1,
      2,
      1,
      0.900203,
      1.350023,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      1,
      0.577819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      0,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.236908,
      NULL,
      NULL,
      2,
      3.033983,
      0.326275,
      0,
      NULL,
      3,
      4.307037,
      1.119587,
      1.987496,
      3.748724,
      3.193797,
      4.724728,
      1.093481,
      NULL,
      NULL,
      1.127774,
      NULL,
      0,
      0.078295,
      NULL,
      1,
      0,
      5,
      4,
      NULL,
      NULL,
      1,
      1.991787,
      NULL,
      1,
      3.607208,
      1.111961,
      1.346810,
      NULL,
      NULL,
      1.756234,
      4.797681,
      8,
      2,
      NULL,
      3.440772,
      5,
      5.728391,
      6.366302,
      4,
      7,
      NULL,
      4.433069,
      2.300249,
      1.591500,
      1,
      2.576196,
      NULL,
      7,
      NULL,
      2,
      NULL,
      0,
      4.294323,
      0,
      NULL,
      2,
      NULL,
      NULL,
      4.279516,
      0.797032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683947,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.431283,
      3.829750,
      NULL,
      NULL,
      NULL,
      NULL,
      5.477017,
      1.950521,
      2,
      3.037615,
      0.006468,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.905406,
      0.720442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.668250,
      0,
      2,
      NULL,
      2.674147,
      0.148533,
      2,
      1.442708,
      0.821585,
      3,
      0,
      0.309360,
      1,
      0,
      0,
      1.360341,
      NULL,
      NULL,
      0.696807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '44001',
      '',
      '',
      0.368185,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


