set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      '4231100',
      6,
      0,
      0,
      0,
      '244402',
      3.653837,
      NULL,
      14,
      NULL,
      1.776091,
      NULL,
      1,
      1.216047,
      3.809530,
      1,
      1,
      1,
      0.725526,
      0.432418,
      0.207412,
      0.219630,
      7,
      0,
      NULL,
      0,
      0,
      0.451777,
      4,
      NULL,
      0,
      NULL,
      0.824179,
      1.139866,
      7,
      3,
      5.835049,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.209403,
      NULL,
      NULL,
      3,
      1.431532,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.568592,
      NULL,
      NULL,
      0.619987,
      NULL,
      NULL,
      0.693491,
      2.438530,
      NULL,
      5,
      1.036898,
      NULL,
      0,
      0,
      0.191012,
      1,
      3,
      1,
      1.071152,
      1.003991,
      0,
      0.889695,
      NULL,
      0.086322,
      4,
      3,
      0,
      0,
      1.363011,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.106808,
      0.819887,
      NULL,
      3.290028,
      7,
      1.377639,
      8,
      NULL,
      6.467627,
      NULL,
      9.957087,
      7,
      0.455241,
      NULL,
      0.633996,
      3,
      0.039955,
      0.890113,
      2,
      0.130116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654299,
      1.426674,
      1,
      0,
      1,
      1,
      1.119443,
      0.938433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.463720,
      NULL,
      NULL,
      NULL,
      0.805369,
      3,
      NULL,
      1.146847,
      1.804944,
      NULL,
      NULL,
      6.000367,
      NULL,
      0.705814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.968228,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.199306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.285762,
      2,
      NULL,
      0,
      2,
      2.520175,
      1.397010,
      2,
      3,
      1,
      NULL,
      NULL,
      0,
      1.106547,
      0.404272,
      0.096192,
      0.189670,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '03212',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


