set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '1222241',
      NULL,
      NULL,
      0,
      0,
      '424240',
      3.891828,
      '11-23-1975',
      10,
      NULL,
      1,
      NULL,
      3.393193,
      0.207871,
      2,
      0.739223,
      1.573033,
      3,
      0,
      0,
      0.412570,
      0.868283,
      1,
      1,
      1.508469,
      1,
      0,
      3.980261,
      0,
      0.400329,
      1,
      0.754377,
      NULL,
      1.649522,
      3,
      3,
      0.764370,
      0.212483,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.683252,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      3,
      0,
      3,
      1,
      1.606750,
      3,
      1.959014,
      1,
      0.084467,
      1.911065,
      NULL,
      1,
      5,
      NULL,
      1,
      6.878872,
      NULL,
      1,
      5.439920,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.439741,
      0,
      NULL,
      1,
      4.131011,
      1.049125,
      3,
      1.662236,
      2,
      0,
      1,
      0.456836,
      1.495463,
      NULL,
      1,
      NULL,
      0,
      0.333667,
      0.822467,
      NULL,
      NULL,
      1,
      1,
      1.621527,
      6,
      1,
      1,
      0.654915,
      0,
      1,
      NULL,
      1,
      7.536769,
      NULL,
      7,
      NULL,
      0,
      NULL,
      4.228290,
      NULL,
      3,
      4.986338,
      9.569806,
      1.454216,
      NULL,
      6.440022,
      1.738547,
      2.783760,
      0.903573,
      NULL,
      0,
      4.460762,
      1.372944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.943732,
      0.714675,
      0,
      0,
      0.625332,
      1.846481,
      NULL,
      1.561250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2.391469,
      0.291870,
      3.880008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3.748978,
      1.663118,
      NULL,
      NULL,
      NULL,
      0.181526,
      6,
      3,
      5.268419,
      3.778324,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.996290,
      8,
      0.740225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.496601,
      1.583776,
      NULL,
      1,
      NULL,
      1,
      0.585248,
      0.818325,
      3.071728,
      1,
      1.289214,
      1,
      1.647247,
      1.728091,
      0.890562,
      NULL,
      1.923613,
      1.923057,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.354389,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


