set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '3340433',
      NULL,
      4,
      0,
      0,
      '144423',
      3,
      NULL,
      8,
      NULL,
      1,
      NULL,
      NULL,
      0.324854,
      1,
      0,
      1,
      2.462155,
      0,
      0,
      NULL,
      1,
      5.899093,
      1.064322,
      1,
      2,
      0.869781,
      0,
      3,
      1,
      0.905046,
      NULL,
      1,
      1.920557,
      NULL,
      NULL,
      3,
      2,
      1,
      1.743176,
      NULL,
      NULL,
      1.241329,
      NULL,
      NULL,
      3.098779,
      0.380876,
      1.950176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.068292,
      1.660582,
      1,
      1,
      NULL,
      0,
      1,
      0.090654,
      NULL,
      NULL,
      1.238222,
      NULL,
      NULL,
      0,
      4.007875,
      NULL,
      0.401183,
      NULL,
      NULL,
      NULL,
      0,
      0.794180,
      NULL,
      0,
      2.336382,
      NULL,
      1,
      0,
      0.769102,
      1,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      0.740642,
      NULL,
      0,
      2.467238,
      1.772873,
      3,
      0.904066,
      1.452774,
      3.950783,
      2.633965,
      NULL,
      4,
      1.317517,
      NULL,
      7.605064,
      3,
      3.535838,
      NULL,
      1.515977,
      NULL,
      NULL,
      2.010049,
      6.857848,
      NULL,
      4.880489,
      NULL,
      0.190713,
      0.285120,
      0.655376,
      1.416133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.145505,
      1,
      1,
      1.373430,
      0.823473,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6.291947,
      0.538868,
      1,
      1.192348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.710910,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.867269,
      3,
      0.884224,
      1,
      1.974645,
      NULL,
      NULL,
      NULL,
      0,
      1.658023,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2.416296,
      3.381120,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.235273,
      1,
      NULL,
      0,
      0,
      1.236189,
      1,
      1.429380,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.708585,
      NULL,
      '23312',
      NULL,
      1.361234,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


