set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '0014330',
      47,
      NULL,
      1.798230,
      3,
      '024433',
      3,
      '11-21-2002',
      33.524838,
      NULL,
      0.558954,
      NULL,
      NULL,
      0,
      2.201800,
      1,
      1.413787,
      0.598011,
      0.443270,
      0.875265,
      0.133577,
      0,
      NULL,
      NULL,
      0.875912,
      0,
      1.126427,
      0.016928,
      NULL,
      1,
      0.528223,
      0.009282,
      1.940853,
      0.746973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845354,
      1.481687,
      1.654545,
      3.394931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294594,
      NULL,
      0,
      5.169361,
      1.919869,
      4.786203,
      1,
      2,
      1.190037,
      0,
      0.525248,
      0.175718,
      2,
      NULL,
      0.451104,
      NULL,
      0,
      0.098362,
      NULL,
      1,
      1,
      0.179764,
      2,
      1.501040,
      1,
      7,
      0.894849,
      1,
      1.442950,
      2,
      NULL,
      1.071619,
      1.762203,
      3.025548,
      0,
      2.775998,
      9.028296,
      3.247026,
      5.572296,
      0.151605,
      1,
      NULL,
      4.454351,
      3.475187,
      6,
      0.295243,
      4,
      1.748454,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064322,
      0,
      0,
      0,
      0.990252,
      1.077762,
      NULL,
      0.387386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.603858,
      NULL,
      0,
      0.148670,
      0,
      0.147696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.813434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2.675373,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.439721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295700,
      3,
      1,
      0,
      0,
      2.589133,
      1.958277,
      1,
      1.656895,
      3,
      NULL,
      0.627656,
      0.397981,
      NULL,
      0,
      1.558425,
      1.926519,
      1,
      NULL,
      NULL,
      NULL,
      0.318186,
      NULL,
      1,
      3,
      2,
      2.657601,
      1,
      0,
      1.411464,
      0.123412,
      0,
      1.061682,
      1,
      1,
      0.956796,
      0,
      1,
      1,
      0.390541,
      0.479001,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.500199,
      '10020',
      '34004',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


