set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '001',
      NULL,
      19.768065,
      10.909088,
      '2440432',
      95.088359,
      5,
      NULL,
      NULL,
      NULL,
      5,
      ' 2- 3-2001',
      34.864483,
      5,
      1.876579,
      NULL,
      3,
      0,
      0.537246,
      1.121438,
      1.579368,
      NULL,
      0.474466,
      0.954957,
      NULL,
      1,
      0,
      1.949948,
      NULL,
      1.692853,
      1.932719,
      NULL,
      0,
      1,
      1,
      0,
      0.855362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406429,
      1,
      1.766572,
      1.490758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979560,
      0.660781,
      0.440560,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426434,
      3,
      4,
      0.751849,
      0,
      1,
      1,
      NULL,
      0.482913,
      1,
      1,
      0.461844,
      1,
      1,
      0.720317,
      0.686702,
      1,
      0,
      1.137615,
      NULL,
      NULL,
      4.816045,
      1.162991,
      2.705299,
      5.607001,
      NULL,
      NULL,
      0,
      1.710018,
      0,
      0.023267,
      NULL,
      NULL,
      0,
      NULL,
      1.008852,
      1.871101,
      2,
      9.294719,
      NULL,
      5.855683,
      0.829274,
      2.293935,
      NULL,
      NULL,
      0,
      NULL,
      5,
      1.449574,
      NULL,
      NULL,
      2,
      1.849416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.922449,
      NULL,
      0,
      1,
      1,
      1.260363,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.614887,
      NULL,
      0.825092,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.911059,
      6.570117,
      0,
      NULL,
      1.363222,
      NULL,
      NULL,
      NULL,
      NULL,
      2.646105,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512895,
      0,
      0.422291,
      2,
      2,
      NULL,
      0.850785,
      0,
      3.311317,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.829707,
      0.924131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815273,
      NULL,
      0,
      NULL,
      1,
      0,
      0.195174,
      2,
      0,
      '00103',
      '22422',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '23200',
      '',
      '',
      0.793307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


