set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      NULL,
      21,
      8.661105,
      '3411410',
      55,
      NULL,
      NULL,
      2,
      '211423',
      5.552084,
      NULL,
      35,
      5.954929,
      1,
      NULL,
      1.340122,
      0,
      NULL,
      1.704154,
      1.743392,
      3,
      NULL,
      1.059502,
      NULL,
      0.876817,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      3.679711,
      0,
      4.243524,
      NULL,
      0.563191,
      1.901351,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.321053,
      1.240592,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.828380,
      0,
      NULL,
      1,
      1,
      1.754495,
      0.895810,
      NULL,
      NULL,
      0.253351,
      NULL,
      NULL,
      0,
      3,
      0,
      0.738398,
      NULL,
      1,
      1.698801,
      NULL,
      0.867331,
      1,
      1,
      1,
      1,
      0,
      1.477566,
      1,
      1.615156,
      0.615377,
      NULL,
      NULL,
      1.828877,
      2.408150,
      5.448218,
      1.802153,
      NULL,
      0,
      3.343862,
      0.869819,
      2,
      0,
      1.852760,
      0,
      NULL,
      0.319474,
      3,
      1.976717,
      NULL,
      NULL,
      8,
      5,
      4.537451,
      4,
      6.435052,
      6.094789,
      9.152001,
      7.358875,
      2,
      7,
      1,
      NULL,
      NULL,
      2,
      1.598841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349860,
      1,
      0,
      1.419405,
      NULL,
      NULL,
      1.296062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.690636,
      NULL,
      NULL,
      1,
      1.403668,
      3,
      1,
      0.766206,
      NULL,
      NULL,
      0.240564,
      3,
      1,
      2.714252,
      2.930461,
      1,
      2.902509,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      8.635171,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.291730,
      NULL,
      3,
      2,
      2.336352,
      NULL,
      2.976061,
      0,
      3.541997,
      1.800660,
      0,
      1.815941,
      1.486669,
      1,
      0.263901,
      1,
      0.984015,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.354786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.149555,
      '14400',
      '21323',
      '',
      0,
      '',
      '',
      '',
      3.149560,
      '41013',
      NULL,
      '',
      3.215467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


