set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '01300422',
      NULL,
      NULL,
      '1123100',
      5,
      5,
      NULL,
      2,
      '014200',
      NULL,
      ' 7- 0-1987',
      39.290593,
      NULL,
      1,
      NULL,
      0.221831,
      0,
      3.424904,
      1.901878,
      1.534638,
      1.709177,
      0,
      1.356656,
      2.232787,
      NULL,
      1,
      1.398079,
      0.926519,
      0.528074,
      1.722288,
      1.913871,
      3,
      1,
      0.612092,
      1.271833,
      0,
      1.548712,
      1.296414,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.058198,
      0.117509,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      3.889450,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      1.249562,
      NULL,
      NULL,
      0.741858,
      5.852301,
      4,
      1,
      5,
      0.804156,
      1,
      0,
      1.373669,
      0,
      0,
      1.190295,
      1,
      0,
      1,
      1.430965,
      1,
      0,
      0.685024,
      NULL,
      1,
      NULL,
      NULL,
      0.856118,
      NULL,
      1,
      1.322902,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      0,
      1.659783,
      0,
      1,
      NULL,
      5.607148,
      1.654263,
      NULL,
      4,
      3,
      4,
      1,
      1.901642,
      NULL,
      NULL,
      NULL,
      1.151633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.033176,
      NULL,
      NULL,
      NULL,
      3,
      4,
      5,
      1,
      1.182579,
      NULL,
      NULL,
      NULL,
      5,
      0.966170,
      NULL,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.620163,
      4,
      1.835768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.763807,
      1.252503,
      1,
      1.372505,
      NULL,
      3,
      NULL,
      0.101756,
      2.344334,
      2.524979,
      0.110503,
      1.813276,
      NULL,
      1.812069,
      1.438830,
      0.409802,
      1.860266,
      NULL,
      0.002500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      '32210',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3.712936,
      '00114',
      '',
      '',
      1,
      NULL,
      1,
      3.964566,
      3.310271,
      0.085885,
      NULL,
      NULL,
      3);
commit;
end;
/


