set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03400102',
      24,
      26,
      '3323242',
      232.443329,
      4,
      0,
      0,
      '330332',
      3,
      ' 4- 0-1986',
      22.349407,
      47,
      0.970037,
      NULL,
      0,
      NULL,
      0.071449,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389830,
      4.831295,
      0,
      0,
      0,
      1.536344,
      0,
      5.209796,
      1.712507,
      3.243743,
      1.949616,
      0,
      NULL,
      1,
      1,
      2.828860,
      1,
      NULL,
      1.342866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.403975,
      0.313443,
      1,
      0,
      NULL,
      0,
      1.157925,
      0.955316,
      1,
      2.871429,
      2,
      0.818016,
      0.471759,
      1.802974,
      1.710766,
      1.990670,
      1,
      1.548456,
      1,
      0.145245,
      6,
      0.924147,
      1,
      0,
      1,
      2.480869,
      1.270068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526485,
      0,
      0.910820,
      0,
      1,
      0,
      0.945728,
      1.809155,
      NULL,
      0.398024,
      0,
      0,
      0.971227,
      0.789938,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.436949,
      NULL,
      NULL,
      0.004096,
      NULL,
      1,
      1.398225,
      2.791129,
      NULL,
      NULL,
      NULL,
      NULL,
      2.213871,
      1,
      2,
      1,
      0.557403,
      2.463269,
      7.643058,
      2.348262,
      3,
      6,
      0,
      NULL,
      5.839247,
      7.521704,
      2.137798,
      3.973682,
      1.123439,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995421,
      0.280172,
      0,
      NULL,
      0,
      0.767145,
      1.445489,
      1.922911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.743783,
      2.383434,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.161246,
      6.959660,
      0.436651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.198983,
      3,
      2.774636,
      2.699543,
      0.912376,
      3.693418,
      1,
      1,
      NULL,
      0.088719,
      0.680864,
      NULL,
      1.276407,
      0,
      NULL,
      1.037727,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      '21311',
      '43034',
      NULL,
      0,
      '',
      '',
      NULL,
      3,
      '41322',
      '',
      '',
      2.214121,
      0.116928,
      NULL,
      2.902855,
      NULL,
      NULL,
      NULL,
      2.676165,
      NULL);
commit;
end;
/


