set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '20134414',
      66,
      70,
      '4232200',
      158,
      1,
      3,
      0,
      '340443',
      4,
      '11-11-1991',
      NULL,
      13.811186,
      1.370008,
      NULL,
      NULL,
      NULL,
      2.267272,
      0,
      1.478383,
      0,
      NULL,
      1,
      2,
      1.532568,
      3.501837,
      1.063204,
      1,
      NULL,
      0.895225,
      NULL,
      5.604985,
      1,
      0.486156,
      1,
      1.992272,
      0.873482,
      1.346815,
      0,
      0.083847,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.249909,
      NULL,
      NULL,
      NULL,
      5.102089,
      1.863783,
      1,
      0,
      0.512153,
      1,
      0,
      0,
      NULL,
      1,
      0,
      1.176339,
      1.693130,
      0,
      1.600113,
      1,
      3,
      3,
      0,
      NULL,
      1,
      3.274069,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0.562967,
      NULL,
      NULL,
      1.954833,
      3,
      0,
      NULL,
      NULL,
      0.640920,
      1,
      1,
      1.220811,
      1,
      1.166610,
      NULL,
      NULL,
      1.137474,
      1,
      1.424811,
      0.147015,
      1.826818,
      0,
      NULL,
      NULL,
      3,
      0.160479,
      0,
      4,
      1.522233,
      0,
      2.628598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0.220097,
      0.665048,
      7,
      0.341572,
      2.987092,
      3.210891,
      9,
      NULL,
      3,
      2,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131150,
      1.689627,
      1,
      0,
      NULL,
      0,
      1.692894,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.715653,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.077805,
      0.540415,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.274850,
      1.406382,
      0.059615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205425,
      2.936543,
      1.514665,
      NULL,
      0.246514,
      0.358604,
      2.151601,
      3.204566,
      1,
      NULL,
      1.222969,
      1,
      NULL,
      1,
      0,
      0.371497,
      1,
      0,
      0,
      0.226995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '03112',
      '00340',
      '',
      NULL,
      '',
      '',
      '',
      3.656212,
      '23331',
      '',
      '',
      4,
      NULL,
      0,
      2.319937,
      2,
      NULL,
      3.441448,
      3.782421,
      NULL);
commit;
end;
/


