set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8815213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '203',
      '04201334',
      52.795446,
      20,
      NULL,
      306,
      0,
      2.682941,
      3,
      '312430',
      1.130257,
      ' 4-20-1975',
      6,
      37,
      1,
      NULL,
      NULL,
      1,
      1.942608,
      1,
      0,
      1.209805,
      NULL,
      0,
      2.803999,
      0,
      NULL,
      NULL,
      0,
      1.751207,
      NULL,
      1.596075,
      0,
      0,
      1.004323,
      NULL,
      0.690749,
      1.083468,
      2,
      0,
      0.882638,
      1.183081,
      0.484356,
      0.358768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.110920,
      0.544377,
      NULL,
      NULL,
      0.825301,
      1.543104,
      2.550380,
      3,
      0,
      0,
      NULL,
      1.002385,
      0,
      1,
      0.737724,
      1.353316,
      0,
      2.394793,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.314934,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      0.829819,
      1,
      1.320216,
      0,
      1.896299,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      2,
      0,
      0.062028,
      NULL,
      3,
      1.436987,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.767931,
      NULL,
      1,
      1.508318,
      NULL,
      3.385076,
      NULL,
      4.606620,
      NULL,
      8.157772,
      9.639520,
      NULL,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023924,
      1,
      0,
      NULL,
      0.504990,
      1.632244,
      0.230047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644672,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770779,
      NULL,
      3.536553,
      1.819093,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      6.989022,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      7.846955,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363521,
      NULL,
      1.473046,
      0,
      3.109345,
      3.928580,
      2.329063,
      1,
      3.668008,
      NULL,
      0.211611,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.623773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.294692,
      '13323',
      '03123',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '00241',
      '',
      '',
      2,
      NULL,
      0.451563,
      1,
      2.966299,
      NULL,
      2,
      3.980265,
      3.027064);
commit;
end;
/


